#!/bin/bash

len=0
nmove=1
pipelen=1
bound=0
exps=0
max=1

while getopts "m:l:M:b:e" c
do
    case $c in
	m) nmove=$OPTARG;;
	l) pipelen=$OPTARG;;
	M) max=$OPTARG;;
	b) bound=$OPTARG;;
	e) exps=1;;
    esac
done

shift $(($OPTIND - 1))

if [[ $# -lt 1 ]] ; then
    echo "$0 [options] <length>  where <length> >= 2"
    exit 1
fi

len=$1

if [[ $len -lt 2 ]] ; then
    echo "$0: line length must be at least 2"
    exit 1
fi

# figure out max counter value
if [[ $max -lt 1 ]]; then
    max=1
fi
if [[ $bound -gt $max ]]; then
    max=$bound
fi
if [[ $exps -gt 0 ]]; then
    if [[ $max -lt $((2 * len)) ]]; then
	max=$((2 * len))
    fi
fi

echo "(define (problem pwt-line-$len)"
echo "  (:domain pipesworld-tankage-ae)"

echo "  (:objects"
i=1
while [[ $i -le $len ]]; do
    echo "  A$i - area"
    if [[ $i -gt 1 ]]; then
	j=$((i-1))
	echo "  S$j$i - pipe"
    fi
    i=$((i+1))
done
i=2
while [[ $i -le $max ]]; do
    echo "  C$i - count"
    i=$((i+1))
done

# end :objects
echo "  )"

echo "  (:init"
# counters
i=0
while [[ $i -lt $max ]]; do
    j=$((i+1))
    echo "   (inc C$i C$j)"
    i=$((i+1))
done

# static stuff
echo "   (may-interface LCO LCO)"
echo "   (may-interface GASOLEO GASOLEO)"
echo "   (may-interface LCO GASOLEO)"
echo "   (may-interface GASOLEO LCO)"

# init pipes
i=1
while [[ $i -lt $len ]]; do
    j=$((i+1))
    echo "   (connect A$i A$j S$i$j)"
    echo "   (length S$i$j C1)"
    echo "   (contents S$i$j C1 LCO)"
    echo "   (normal S$i$j)"
    if [[ $bound -gt 0 ]]; then
	echo "   (max-op S$i$j C$bound)"
    fi
    i=$((i+1))
done

# init areas
if [[ $exps -gt 0 ]]; then
    j=$((2 * len))
    echo "   (number-on LCO A1 C0)"
    echo "   (free-space LCO A1 C$j)"
    echo "   (number-on GASOLEO A1 C$j)"
    echo "   (free-space GASOLEO A1 C0)"
else
    echo "   (number-on LCO A1 C0)"
    echo "   (free-space LCO A1 C1)"
    echo "   (number-on GASOLEO A1 C1)"
    echo "   (free-space GASOLEO A1 C0)"
fi

i=2
while [[ $i -le $len ]]; do
    echo "   (number-on LCO A$i C1)"
    echo "   (free-space LCO A$i C0)"
    echo "   (number-on GASOLEO A$i C0)"
    echo "   (free-space GASOLEO A$i C1)"
    i=$((i+1))
done

# end :init
echo "   )"

echo -n "  (:goal (and (number-on LCO A1 C1) (number-on GASOLEO A$len C1)"
i=1
while [[ $i -lt $len ]]; do
    j=$((i+1))
    echo -n " (normal S$i$j)"
    i=$((i+1))
done
echo "))"

# end problem
echo " )"
