#!/bin/bash

pwnsrcdir=../../ipc4/pipesworld/notankage-nontemporal/strips
pwtsrcdir=../../ipc4/pipesworld/tankage-nontemporal/strips

# create directories if needed
mkdir -p pwn/simple_goal_max9
mkdir -p pwn/add_goal_max9
mkdir -p pwt/simple_goal_max9
mkdir -p pwt/add_goal_max9

# convert notankage problems with simple goals
for file in $pwnsrcdir/p??_*.pddl; do
    ./convert-ipc4-problem -max 9 $file > pwn/simple_goal_max9/`basename $file .pddl`.pddl
done

# convert notankage problems with additive goals
for file in $pwnsrcdir/p??_*.pddl; do
    ./convert-ipc4-problem -max 9 -add $file > pwn/add_goal_max9/`basename $file .pddl`.pddl
done

# convert tankage problems with simple goals
for file in $pwtsrcdir/p??_*.pddl; do
    ./convert-ipc4-problem -max 9 $file > pwt/simple_goal_max9/`basename $file .pddl`.pddl
done

# convert tankage problems with additive goals
for file in $pwtsrcdir/p??_*.pddl; do
    ./convert-ipc4-problem -max 9 -add $file > pwt/add_goal_max9/`basename $file .pddl`.pddl
done

# generate graphs
./convert-ipc4-problem -g $pwnsrcdir/p01_net1_b6_g2.pddl > net1.dot
./convert-ipc4-problem -g $pwnsrcdir/p11_net2_b10_g2.pddl > net2.dot
./convert-ipc4-problem -g $pwnsrcdir/p21_net3_b12_g2.pddl > net3.dot
./convert-ipc4-problem -g $pwnsrcdir/p31_net4_b14_g3.pddl > net4.dot
./convert-ipc4-problem -g $pwnsrcdir/p41_net5_b22_g2.pddl > net5.dot
