#include <math.h>
#include <boost/numeric/ublas/vector.hpp>
#include <iostream>

using namespace boost::numeric::ublas;


/*
Solve the following constrained diagonal QP
min 0.5 * dsq[i] * (x_i - offset[i])^2   (dsq stands for d square)
s.t.   lower_bound[i] \le x[i] \le upper_bound[i]
       \sum_i sigma[i] * x[i] = z

Based on inner piecewise linear function root finding:
h_i(\lambda) =  ( min( sigma[i] * (lower[i] - offset[i]), sigma[i] * (upper[i] - offset[i]) )
                (           if \lambda < min ( dsq[i] / sigma[i] * (lower[i] - offset[i]), 
                (                              dsq[i] / sigma[i] * (upper[i] - offset[i]) )
                ( max( sigma[i] * (lower[i] - offset[i]), sigma[i] * (upper[i] - offset[i]) )
                (           if \lambda > max ( dsq[i] / sigma[i] * (lower[i] - offset[i]), 
                (                              dsq[i] / sigma[i] * (upper[i] - offset[i]) )
                ( \lambda else
*/
class CDiagQPSolver
{
protected:
    class CPiece
    {
    public:
        int index;
        double x_low, x_high;
        double y_low, y_high;
        double slope;
        int status;
        CPiece *next;
        CPiece () {status = 0; next = 0;}
        void Print() {
            std::cout << "index = " << index << ", slope = " << slope << std::endl;
            std::cout << "x_low = " << x_low << ", x_high = " << x_high << std::endl;
            std::cout << "y_low = " << y_low << ", y_high = " << y_high << std::endl;
            std::cout << "-----------\n";
        }
    };

    int n;
    double z;

    double cumulateDsq;
    double fixedSum;

    double * lower_bound;
    double * upper_bound;
    double * dsq;
    double * offset;
    double * sigma;

    CPiece * pieceList; // list of all ramps
    CPiece * unsetList; // list of unset ramps

    double * dataPool;  // The list of hinge points lying in the current interval
    int dataPoolIndex;  // Number of such hinge points in current list

    double median_x;
    bool larger;        // Is the inner piecewise function value at median_x greater than z or not
    double ori_z;

public:
    CDiagQPSolver(int _n, vector<double> &_lower, vector<double> & _upper,
        vector<double> & _dsq, vector<double> & _sigma, vector<double> & _offset, double _z);
    
    ~CDiagQPSolver();

    double evaluateObj();

    bool processPiece(CPiece * ptr_cur);

    void Solve(vector<double> & result);

    void check_result(vector<double> & solution);

    void dumpToFile(char * filenaem);
};
