#include <math.h>
#include <boost/numeric/ublas/vector.hpp>
#include <iostream>

using namespace boost::numeric::ublas;


/*
Solve the following box constrained diagonal QP
min 0.5 * dsq[i] * (x_i - offset[i])^2   (dsq stands for d square)
s.t.   lower_bound[i] \le x[i] \le upper_bound[i]       
*/
class CDiagBoxQPSolver
{
protected:

    int n;

    double * lower_bound;
    double * upper_bound;
    double * offset;
    double * sigma;

public:
    CDiagBoxQPSolver(int _n, vector<double> &_lower, vector<double> & _upper, vector<double> & _offset);
    
    ~CDiagBoxQPSolver();
    

    void Solve(vector<double> & result);

    void dumpToFile(char * filenaem);
};
