#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <algorithm>
#include <iostream>
#include <boost/numeric/ublas/io.hpp>

#include "l2_box_projection.hpp"

//#define MYDEBUG
//#define MYDEBUG_VERBOSE

CDiagBoxQPSolver::~CDiagBoxQPSolver()
{
}


CDiagBoxQPSolver::CDiagBoxQPSolver(int _n, vector<double> &_lower_bound, vector<double> & _upper_bound, 
                                   vector<double> & _offset) : n(_n)
{
    offset = &(_offset.data()[0]);
    lower_bound = &(_lower_bound.data()[0]);
    upper_bound = &(_upper_bound.data()[0]);
}



void CDiagBoxQPSolver::dumpToFile(char * filename)
{
    FILE *fp = fopen(filename, "w");
    int i;

    fprintf(fp, "%d\n", n);
    for (i = 0; i < n; i++)
        fprintf(fp, "%lg\n", lower_bound[i]);
    for (i = 0; i < n; i++)
        fprintf(fp, "%lg\n", upper_bound[i]);
        fprintf(fp, "%lg\n", offset[i]);
    fclose(fp);
}




void CDiagBoxQPSolver::Solve(vector<double> & solution)
{
    for (int i = 0; i < n; i ++)
    {
        if (offset[i] > upper_bound[i])
            solution[i] = upper_bound[i];
        else if (offset[i] < lower_bound[i])
            solution[i] = lower_bound[i];
        else
            solution[i] = offset[i];
    }
}

