function [B M] = project_gd(A,c,thresh,M)

n = length(A);

eval = @(M) myeval(M,A,c);

if nargin < 4
    M = zeros(n);
end

% experimentally, accurate to around 10*thresh

step = 1;

g = -inf;
for reps=1:10000
    Mlast = M;
    glast = g;
    [g, dM] = eval(M);
    M = M + step*dM;
    M = max(M,0);
    
    if g < glast
        step = step/2
    end
    
    diff = norm(M(:)-Mlast(:),'inf')
    if diff < thresh
        reps
        break;
    end
end

[~,~,B] = eval(M);

end

function [g dM B] = myeval(M,A,c)
R = abs(A);

[U S V] = svd(R + M);

S(S>c) = c;
D = U*S*V';

g  = .5*norm(D-R,'fro')^2 - sum(sum(M.*D));
dM = -D;

B = D.*sign(A);

if rand < .1
    imagesc(B)
    drawnow
end
end
