function B = project_cvx(A,c)

n = length(A);

if n > 20
    error('this doesnt work efficiently enough for large models')
end

cvx_begin quiet
    variable B(n,n)
    variable Z(n,n)
    minimize(norm(A-B,'fro'))
    subject to
        norm( Z, 2) <= c
        Z >= abs(B)
        B == B.'
cvx_end